Summary: PPD files for Citizen POS printers.
Name: ctzpos-cups
License: GPL
Version: 1.2.8
Release: 0
Group: System Environment/Libraries
Source0: ctzpos-cups-%{version}.tar.bz2
BuildRoot: %{_tmppath}/%{name}-%{version}-root
#BuildArch: i386
Requires: cups
BuildRequires: cups-devel
%description
ctzpos-cups is PPD files collection for printing with CITIZEN POS printers.
%global debug_package %{nil}
%undefine _missing_build_ids_terminate_build

%prep
%setup -q
#%setup -n %{name}-%{version}
#tar jxf %{SOURCE0}

%build
for SRC in *.c; do
   OBJ=`echo $SRC |sed "s/\.c//"`
   gcc -Wl,-rpath,/usr/lib -Wall -fPIC -O2 -o $OBJ $SRC -lcupsimage -lcups
done

%install
mkdir -p %{buildroot}%{_datadir}/cups/model/ \
         %{buildroot}%{_libdir}/cups/filter
install -m 0644 *.ppd %{buildroot}%{_datadir}/cups/model/
for SRC in *.c; do
   OBJ=`echo $SRC |sed "s/\.c//"`
   install -c -m 0755 $OBJ %{buildroot}%{_libdir}/cups/filter
done

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root)
%{_datadir}/cups/model/*.ppd
%{_libdir}/cups/filter/*

%post
rpm -q cups || exit 0
CUPSINIT=`rpm -ql cups | grep "init\.d" `
if [ -n "$CUPSINIT" ] ; then
    $CUPSINIT restart
else
     systemctl stop  cups.service
     systemctl start cups.service
fi

%postun
rpm -q cups || exit 0
CUPSINIT=`rpm -ql cups | grep "init\.d" `
if [ -n "$CUPSINIT" ] ; then
    $CUPSINIT restart
else
     systemctl stop  cups.service
     systemctl start cups.service
fi

%changelog
* Tue Oct 24 2023 Citizen Systems <sales-eg@systems.citizen.co.jp> 1.2.8-0
- Added a model (CT-S801III/CT-S851III)

* Tue Jul 12 2022 Citizen Systems <sales-eg@systems.citizen.co.jp> 1.2.7-0
- Added a model (PMU3300/CT-S280II/CT-S281II)

* Wed Feb 24 2021 Citizen Systems <sales-eg@systems.citizen.co.jp> 1.2.6-0
- Added PaperMedia option (CT-D101/CT-E301/CT-E601)

* Fri Nov 27 2020 Citizen Systems <sales-eg@systems.citizen.co.jp> 1.2.5-0
- Added PaperMedia option (CT-D151/CT-E651/CT-S255)
  "Label/BM Paper" can be selected

* Thu Jan 17 2019 Citizen Systems <sales-eg@systems.citizen.co.jp> 1.2.4-0
- Added NEW model (CT-S4500)

* Wed Nov 14 2018 Citizen Systems <sales-eg@systems.citizen.co.jp> 1.2.3-0
- Added NEW model (CT-S257/S751)

* Tue May 23 2017 Citizen Systems <sales-eg@systems.citizen.co.jp> 1.2.2-0
- Added NEW model (CT-D151/CT-E651/CT-S255)
- Fixed CT-S251

* Tue Mar 28 2017 Citizen Systems <sales-eg@systems.citizen.co.jp> 1.2.1-1
- Added model (CMP-20/30)

* Tue Dec  6 2016 Citizen Systems <sales-eg@systems.citizen.co.jp> 1.2.1-0
- Added NEW model (CT-D150/CT-E351/CT-S253)

* Thu Dec 18 2014 Citizen Systems <sales-eg@systems.citizen.co.jp> 1.2.0-0
- Added NEW model (CT-S251/601II/651II/801II/851II)
- Supported the paper media in the lavel models.

* Tue Aug 12 2014 Citizen Systems <sales-eg@systems.citizen.co.jp> 1.1.3-0
- Added NEW model (CT-S401)
- Supported the buzzer option.

* Tue Jan 21 2014 Citizen Systems <sales-eg@systems.citizen.co.jp> 1.1.2-1
- Supported the cash drawer of CT-S281.
- Added the end job command.

* Fri Aug  9 2013 Citizen Systems <sales-eg@systems.citizen.co.jp> 1.1.1-0
- Filters were modified. Added width linitation.

* Tue Jun 12 2012 Satoshi IMAMURA <imamura@systems.citizen.co.jp> 1.1.0-1
- Able to install to the system which uses systemd.
- Able to build packages for architecture which is not i386.
- Tested on Fedora 17 (x86_64) and Scientific Linux 6.2 (i686)

* Tue Jun  5 2012 Citizen Systems <sales-eg@systems.citizen.co.jp> 1.1.0-0
- Supported the receipt paper type and the partial cut.
- Add NEW model (PMU22XX/PMU23XX)

* Mon Apr 18 2011 Satoshi IMAMURA <imamura@systems.citizen.co.jp> 1.0.3-0
- Add NEW model (CT-S310II)

* Wed Jul  7 2010 Satoshi IMAMURA <imamura@systems.citizen.co.jp> 1.0.2-0
- Filters were modified
- To avoid from the limitation that too long image (more than 2304 dots; printer
  recognizes the image data as text data) cannot be printed, a long image will 
  be divided severally.

* Wed Jul  7 2010 Satoshi IMAMURA <imamura@systems.citizen.co.jp> 1.0.1-0
- Add new printers.

* Fri Dec 21 2007 Satoshi IMAMURA <imamura@systems.citizen.co.jp> 1.0.0-0
- First shipping
- Checked with RedHat 9.0 / VineSeed (Vine Linux 4.1)
